#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#ifndef _MSC_VER
#include <unistd.h>
#endif

int main(int argc, char **argv) {
    char data[10];
    int fd, size;

    if (argc != 2) {
        fprintf(stderr, "Incorrect number of arguments, got %i\n", argc);
        return 1;
    }
    fd = open(argv[1], O_RDONLY);
    if (fd < 0) {
        fprintf(stderr, "First argument is wrong.\n");
        return 1;
    }

    size = read(fd, data, 8);
    if (size < 0) {
        fprintf(stderr, "Failed to read: %s\n", strerror(errno));
        return 1;
    }
    if (strncmp(data, "contents", 8) != 0) {
        fprintf(stderr, "Contents don't match, got %s\n", data);
        return 1;
    }
    return 0;
}
